/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.biomes.AlpineHeightsBiome;
import projectvibrantjourneys.common.biomes.AspenGroveBiome;
import projectvibrantjourneys.common.biomes.AutumnalConiferousForestBiome;
import projectvibrantjourneys.common.biomes.BaobabFieldsBiome;
import projectvibrantjourneys.common.biomes.BlossomingFieldsBiome;
import projectvibrantjourneys.common.biomes.BorealForestBiome;
import projectvibrantjourneys.common.biomes.BorealPlateauBiome;
import projectvibrantjourneys.common.biomes.CrimsonThicketBiome;
import projectvibrantjourneys.common.biomes.CrystalLakesBiome;
import projectvibrantjourneys.common.biomes.DesertShrublandBiome;
import projectvibrantjourneys.common.biomes.GravelShoreBiome;
import projectvibrantjourneys.common.biomes.MangroveMarshBiome;
import projectvibrantjourneys.common.biomes.OvergrownSpiresBiome;
import projectvibrantjourneys.common.biomes.PineMeadowsBiome;
import projectvibrantjourneys.common.biomes.PrairieBiome;
import projectvibrantjourneys.common.biomes.RedRockValleyBiome;
import projectvibrantjourneys.common.biomes.RedwoodsBiome;
import projectvibrantjourneys.common.biomes.VerdantSandsBiome;
import projectvibrantjourneys.common.biomes.WillowWetlandsBiome;
import projectvibrantjourneys.common.biomes.WindsweptCliffsBiome;
import projectvibrantjourneys.core.PVJConfig;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJBiomes {
    public static final List<Biome> BIOMES = new ArrayList<Biome>();
    public static final Map<RegistryKey<Biome>, RegistryKey<Biome>> SHORE_MAP = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    public static final Map<RegistryKey<Biome>, RegistryKey<Biome>> HILLS_MAP = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    public static final Map<RegistryKey<Biome>, RegistryKey<Biome>> RIVER_MAP = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    public static Biome overgrown_spires = PVJBiomes.register(OvergrownSpiresBiome.makeShatteredJungleBiome(), "overgrown_spires");
    public static Biome verdant_sands = PVJBiomes.register(VerdantSandsBiome.makeVerdantSandsBiome(), "verdant_sands");
    public static Biome redwoods = PVJBiomes.register(RedwoodsBiome.makeRedwoodsBiome(0.19f, 0.31f, 0.45f, 0.6f, false), "redwoods");
    public static Biome redwood_peaks = PVJBiomes.register(RedwoodsBiome.makeRedwoodsBiome(3.0f, 1.0f, 0.4f, 0.55f, false), "redwood_peaks");
    public static Biome snowy_redwoods = PVJBiomes.register(RedwoodsBiome.makeRedwoodsBiome(0.19f, 0.31f, 0.3f, 0.4f, true), "snowy_redwoods");
    public static Biome boreal_forest = PVJBiomes.register(BorealForestBiome.makeBorealForestBiome(false), "boreal_forest");
    public static Biome snowy_boreal_forest = PVJBiomes.register(BorealForestBiome.makeBorealForestBiome(true), "snowy_boreal_forest");
    public static Biome alpine_heights = PVJBiomes.register(AlpineHeightsBiome.makeAlpineHeightsBiome(5.0f, 1.1f), "alpine_heights");
    public static Biome pine_meadows = PVJBiomes.register(PineMeadowsBiome.makePineMeadowsBiome(), "pine_meadows");
    public static Biome boreal_plateau = PVJBiomes.register(BorealPlateauBiome.makeBorealPlateauBiome(), "boreal_plateau");
    public static Biome aspen_grove = PVJBiomes.register(AspenGroveBiome.makeAspenGroveBiome(0.2f, 0.2f), "aspen_grove");
    public static Biome aspen_grove_hills = PVJBiomes.register(AspenGroveBiome.makeAspenGroveBiome(0.45f, 0.25f), "aspen_grove_hills");
    public static Biome mangrove_marsh = PVJBiomes.register(MangroveMarshBiome.makeMangroveMarshBiome(), "mangrove_marsh");
    public static Biome willow_wetlands = PVJBiomes.register(WillowWetlandsBiome.makeWillowWetlandsBiome(), "willow_wetlands");
    public static Biome baobab_fields = PVJBiomes.register(BaobabFieldsBiome.makeBaobabFieldsBiome(), "baobab_fields");
    public static Biome prairie = PVJBiomes.register(PrairieBiome.makePrairieBiome(), "prairie");
    public static Biome blossoming_fields = PVJBiomes.register(BlossomingFieldsBiome.makeBlossomingFieldsBiome(), "blossoming_fields");
    public static Biome autumnal_coniferous_forest = PVJBiomes.register(AutumnalConiferousForestBiome.makeAutumnalConiferousForestBiome(), "autumnal_coniferous_forest");
    public static Biome gravel_shore = PVJBiomes.register(GravelShoreBiome.makeGravelShoreBiome(), "gravel_shore");
    public static Biome crimson_thicket = PVJBiomes.register(CrimsonThicketBiome.makeCrimsonThicketBiome(), "crimson_thicket");
    public static Biome desert_shrubland = PVJBiomes.register(DesertShrublandBiome.makeDesertShrublandBiome(0.2f), "desert_shrubland");
    public static Biome red_rock_valley = PVJBiomes.register(RedRockValleyBiome.makeRedRockValleyBiome(), "red_rock_valley");
    public static Biome tropical_beach = PVJBiomes.register(BiomeMaker.func_244208_a((float)0.0f, (float)0.025f, (float)1.4f, (float)0.8f, (int)4159204, (boolean)false, (boolean)false), "tropical_beach");
    public static Biome crystal_lakes = PVJBiomes.register(CrystalLakesBiome.makeCrystalLakesBiome(), "crystal_lakes");
    public static Biome windswept_cliffs = PVJBiomes.register(WindsweptCliffsBiome.makeWindsweptCliffsBiome(), "windswept_cliffs");

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        BIOMES.forEach(biome -> event.getRegistry().register((IForgeRegistryEntry)biome));
        PVJBiomes.addBiomes();
        PVJBiomes.addTypes();
        PVJBiomes.mapBiomesForMixins();
    }

    public static Biome register(Biome biome, String name) {
        biome.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        BIOMES.add(biome);
        return biome;
    }

    public static void addBiomes() {
        if (((Boolean)PVJConfig.overgrown_spires.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.OVERGROWN_SPIRES, ((Integer)PVJConfig.overgrown_spires_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.verdant_sands.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.VERDANT_SANDS, ((Integer)PVJConfig.verdant_sands_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.redwoods.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.REDWOODS, ((Integer)PVJConfig.redwoods_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.redwood_peaks.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.REDWOOD_PEAKS, ((Integer)PVJConfig.redwood_peaks_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.snowy_redwoods.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.SNOWY_REDWOODS, ((Integer)PVJConfig.snowy_redwoods_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.boreal_forest.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.BOREAL_FOREST, ((Integer)PVJConfig.boreal_forest_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.snowy_boreal_forest.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.SNOWY_BOREAL_FOREST, ((Integer)PVJConfig.snowy_boreal_forest_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.alpine_heights.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.ALPINE_HEIGHTS, ((Integer)PVJConfig.alpine_heights_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.pine_meadows.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.PINE_MEADOWS, ((Integer)PVJConfig.pine_meadows_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.boreal_plateau.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.BOREAL_PLATEAU, ((Integer)PVJConfig.boreal_plateau_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.aspen_grove.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.ASPEN_GROVE, ((Integer)PVJConfig.aspen_grove_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.mangrove_marsh.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.MANGROVE_MARSH, ((Integer)PVJConfig.mangrove_marsh_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.willow_wetlands.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.WILLOW_WETLANDS, ((Integer)PVJConfig.willow_wetlands_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.baobab_fields.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.BAOBAB_FIELDS, ((Integer)PVJConfig.baobab_fields_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.prairie.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.PRAIRIE, ((Integer)PVJConfig.prairie_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.blossoming_fields.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.BLOSSOMING_FIELDS, ((Integer)PVJConfig.blossoming_fields_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.autumnal_coniferous_forest.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.AUTUMNAL_CONIFEROUS_FOREST, ((Integer)PVJConfig.autumnal_coniferous_forest_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.crimson_thicket.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.CRIMSON_THICKET, ((Integer)PVJConfig.crimson_thicket_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.desert_shrubland.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.DESERT_SHRUBLAND, ((Integer)PVJConfig.desert_shrubland_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.red_rock_valley.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.RED_ROCK_VALLEY_BIOME, ((Integer)PVJConfig.red_rock_valley_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.crystal_lakes.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.CRYSTAL_LAKES, ((Integer)PVJConfig.crystal_lakes_weight.get()).intValue()));
        }
        if (((Boolean)PVJConfig.windswept_cliffs.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.WINDSWEPT_CLIFFS, ((Integer)PVJConfig.windswept_cliffs_weight.get()).intValue()));
        }
    }

    public static void addTypes() {
        BiomeDictionary.addTypes(Keys.OVERGROWN_SPIRES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.VERDANT_SANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.REDWOODS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.REDWOOD_PEAKS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.SNOWY_REDWOODS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.BOREAL_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.SNOWY_BOREAL_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.ALPINE_HEIGHTS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.PINE_MEADOWS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.CRIMSON_THICKET, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.BOREAL_PLATEAU, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.ASPEN_GROVE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.ASPEN_GROVE_HILLS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.MANGROVE_MARSH, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.WILLOW_WETLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.BAOBAB_FIELDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.PRAIRIE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.BLOSSOMING_FIELDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.AUTUMNAL_CONIFEROUS_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.GRAVEL_SHORE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.DESERT_SHRUBLAND, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.RED_ROCK_VALLEY_BIOME, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.TROPICAL_BEACH, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.CRYSTAL_LAKES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.WINDSWEPT_CLIFFS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD});
    }

    public static void mapBiomesForMixins() {
        PVJBiomes.mapShoreBiome(Keys.ALPINE_HEIGHTS, (RegistryKey<Biome>)Biomes.field_150576_N);
        PVJBiomes.mapShoreBiome(Keys.BOREAL_PLATEAU, (RegistryKey<Biome>)Biomes.field_150576_N);
        PVJBiomes.mapShoreBiome(Keys.REDWOOD_PEAKS, Keys.GRAVEL_SHORE);
        PVJBiomes.mapShoreBiome(Keys.SNOWY_BOREAL_FOREST, (RegistryKey<Biome>)Biomes.field_150577_O);
        PVJBiomes.mapShoreBiome(Keys.SNOWY_REDWOODS, (RegistryKey<Biome>)Biomes.field_150577_O);
        PVJBiomes.mapShoreBiome(Keys.MANGROVE_MARSH, Keys.MANGROVE_MARSH);
        PVJBiomes.mapShoreBiome(Keys.WILLOW_WETLANDS, Keys.WILLOW_WETLANDS);
        PVJBiomes.mapShoreBiome(Keys.AUTUMNAL_CONIFEROUS_FOREST, Keys.GRAVEL_SHORE);
        PVJBiomes.mapShoreBiome(Keys.RED_ROCK_VALLEY_BIOME, (RegistryKey<Biome>)Biomes.field_150589_Z);
        PVJBiomes.mapShoreBiome(Keys.OVERGROWN_SPIRES, Keys.TROPICAL_BEACH);
        PVJBiomes.mapShoreBiome(Keys.WINDSWEPT_CLIFFS, (RegistryKey<Biome>)Biomes.field_150576_N);
        PVJBiomes.mapHillsBiome(Keys.ASPEN_GROVE, Keys.ASPEN_GROVE_HILLS);
    }

    public static void mapShoreBiome(RegistryKey<Biome> biome, RegistryKey<Biome> shore) {
        SHORE_MAP.put(biome, shore);
    }

    public static void mapHillsBiome(RegistryKey<Biome> biome, RegistryKey<Biome> hills) {
        HILLS_MAP.put(biome, hills);
    }

    public static class Keys {
        public static final RegistryKey<Biome> OVERGROWN_SPIRES = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "overgrown_spires"));
        public static final RegistryKey<Biome> VERDANT_SANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "verdant_sands"));
        public static final RegistryKey<Biome> REDWOODS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "redwoods"));
        public static final RegistryKey<Biome> REDWOOD_PEAKS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "redwood_peaks"));
        public static final RegistryKey<Biome> SNOWY_REDWOODS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "snowy_redwoods"));
        public static final RegistryKey<Biome> BOREAL_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "boreal_forest"));
        public static final RegistryKey<Biome> SNOWY_BOREAL_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "snowy_boreal_forest"));
        public static final RegistryKey<Biome> ALPINE_HEIGHTS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "alpine_heights"));
        public static final RegistryKey<Biome> PINE_MEADOWS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "pine_meadows"));
        public static final RegistryKey<Biome> BOREAL_PLATEAU = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "boreal_plateau"));
        public static final RegistryKey<Biome> WILLOW_WETLANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "willow_wetlands"));
        public static final RegistryKey<Biome> MANGROVE_MARSH = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "mangrove_marsh"));
        public static final RegistryKey<Biome> BAOBAB_FIELDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "baobab_fields"));
        public static final RegistryKey<Biome> ASPEN_GROVE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "aspen_grove"));
        public static final RegistryKey<Biome> ASPEN_GROVE_HILLS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "aspen_grove_hills"));
        public static final RegistryKey<Biome> PRAIRIE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "prairie"));
        public static final RegistryKey<Biome> BLOSSOMING_FIELDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "blossoming_fields"));
        public static final RegistryKey<Biome> AUTUMNAL_CONIFEROUS_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "autumnal_coniferous_forest"));
        public static final RegistryKey<Biome> GRAVEL_SHORE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "gravel_shore"));
        public static final RegistryKey<Biome> CRIMSON_THICKET = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "crimson_thicket"));
        public static final RegistryKey<Biome> DESERT_SHRUBLAND = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "desert_shrubland"));
        public static final RegistryKey<Biome> RED_ROCK_VALLEY_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "red_rock_valley"));
        public static final RegistryKey<Biome> TROPICAL_BEACH = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "tropical_beach"));
        public static final RegistryKey<Biome> CRYSTAL_LAKES = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "crystal_lakes"));
        public static final RegistryKey<Biome> WINDSWEPT_CLIFFS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "windswept_cliffs"));
    }
}

